# models.py

from django.contrib.auth.models import BaseUserManager
from django.utils import timezone
import random

class UserManager(BaseUserManager):
    def create_user(self, email, username, phone_number, password=None, **extra_fields):
        if not email:
            raise ValueError('The Email field must be set')
        if not username:
            raise ValueError('The Username field must be set')
        if not phone_number:
            raise ValueError('The Phone number must be set')

        email = self.normalize_email(email)
        extra_fields.setdefault('user_type', 4)  # Default to 'public'

        user = self.model(
            email=email,
            username=username,
            phone_number=phone_number,
            **extra_fields
        )

        if password:
            user.set_password(password)
        else:
            user.set_unusable_password()
        
        user.save(using=self._db)
        return user

    def create_superuser(self, email, username, phone_number=None, password=None, **extra_fields):
        extra_fields.setdefault('is_staff', True)
        extra_fields.setdefault('is_superuser', True)
        extra_fields.setdefault('user_type', 1)  # admin

        if extra_fields.get('is_staff') is not True:
            raise ValueError('Superuser must have is_staff=True.')
        if extra_fields.get('is_superuser') is not True:
            raise ValueError('Superuser must have is_superuser=True.')
        if not phone_number:
            phone_number = ''.join(random.choice('0123456789') for _ in range(13))

        return self.create_user(email, username, phone_number, password, **extra_fields)

    def create_uaepass_user(self, sub, name, email, phone_number=None, emirates_id=None, profile_picture=None):
        """
        Create a user via UAE PASS authentication.
        """
        user = self.model(
            sub=sub,
            username=name,
            email=email,
            phone_number=phone_number,
            emirates_id=emirates_id,
            profile_picture=profile_picture,
            user_type=4,  
            phone_verified=True,  
        )
        user.set_unusable_password()
        user.save(using=self._db)
        return user
