from rest_framework.permissions import BasePermission
from django.conf import settings
from rest_framework.exceptions import APIException
from rest_framework import status



class InvalidAPIKey(APIException):
    status_code = status.HTTP_401_UNAUTHORIZED
    default_detail = {
        'status': False,
        'message': 'Unauthorized API.'
    }
    default_code = 'unauthorized'


class APIKeyPermission(BasePermission):
    def has_permission(self, request, view):
        expected_key = getattr(settings, 'API_KEY', None)
        api_key = request.headers.get('X-API-KEY')

        if not expected_key:
            raise APIException('Server misconfigured: missing API key.', code='server_error')

        if api_key != expected_key:
            raise InvalidAPIKey()

        return True
