from django.db import models
from django.contrib.auth.models import AbstractUser
from user_management.user_manager import UserManager 
from django.core.validators import RegexValidator
# Create your models here.
class User(AbstractUser):

    USER_TYPE = (
        (1, 'admin'),
        (2, 'inspector'),
        (3, 'reviewer'),
        (4, 'contractor'),
        (5, 'owner'),
        (6, 'public'),
    )

    user_type = models.IntegerField(
        choices=USER_TYPE,
        default= 6
    )
    sub = models.CharField(max_length=255, unique=True)
    username = models.CharField(max_length=300)
    phone_number = models.CharField( max_length=13, unique=True, null=True, blank=True)
    email = models.EmailField(unique=True)
    emirates_id = models.CharField(max_length=20, null=True, blank=True)
    profile_picture = models.ImageField(upload_to="profile_pictures/", blank=True, null=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    pdus = models.PositiveIntegerField(default=0)
    user_registered_courses = models.ManyToManyField('course.Course', related_name='registered_course', blank=True , through='course.UserCourse')
    user_watched_video = models.ManyToManyField('course.Video', related_name='registered_video', blank=True)
    
    USERNAME_FIELD = 'email' 
    REQUIRED_FIELDS = ['username',]

    objects = UserManager()
    
    def __str__(self):
        return self.sub