from django.urls import path
from .views import BookFilterView, CollectionListView, BookDetailView, ChatAnswerView, CreateNewChat,\
ComparePDFsView, UploadFiles, GenerateReportView, PublicGenerateReportView, ProjectListView, SubmissionsByProjectView, SubmissionRequestCreateView,\
SubmissionRequestDetailView, SubmissionListView, UpdateSubmissionRestrictedFieldsView, CADVerifierAPIView , SubTestBulkCreateAPIView , ProjectCreateView, GenerateReportByPathView,\
GenerateReportByUploadView
urlpatterns = [
    path('books/filter/', BookFilterView.as_view(), name='book-filter'),
    path('collections/', CollectionListView.as_view(), name='collection-list'),
    path('books/<int:id>/', BookDetailView.as_view(), name='book-detail'),
    path("chat/", ChatAnswerView.as_view(), name="chat"),
    path("create_new_chat/", CreateNewChat.as_view(), name='create-new-chat'),
    path("compare/", ComparePDFsView.as_view(), name="compare-pdfs"),
    path("upload/", UploadFiles.as_view(), name="upload-files"),
    path('project/report/<int:pk>/', GenerateReportView.as_view(), name='project-report'),
    path('public/report/<int:pk>/', PublicGenerateReportView.as_view(), name='public-project-report'),
    path('project/report/generate/', GenerateReportByPathView.as_view(), name='project-report-by-path'),
    path('project/report/generatebyfile/', GenerateReportByUploadView.as_view(), name='project-report-by-file'),
    path('project/all/', ProjectListView.as_view(), name='project-list'),
    path('project/create/', ProjectCreateView.as_view(), name='project-create'),
    path('project/submissions/<int:project_id>/', SubmissionsByProjectView.as_view(), name="project-submissions"),
    path('project/submission/create/', SubmissionRequestCreateView.as_view(), name="project-submissions-create"),
    path('project/submission/<int:id>/', SubmissionRequestDetailView.as_view(), name="project-submissions-detail"),
    path('project/submission/all/', SubmissionListView.as_view(), name="project-submissions-all"),
    path('project/submission/<int:pk>/update/', UpdateSubmissionRestrictedFieldsView.as_view(), name='update-submission'),
    path('project/cad-verifier/', CADVerifierAPIView.as_view(), name='cad-verifier'),
    path('project/bulk-txt/', SubTestBulkCreateAPIView.as_view(), name='bulk-text'),
    
]
