from django.db.models.signals import post_save, pre_save
from django.dispatch import receiver
from .models import Book
from library.utils import upload_pdf_to_openai
 

# @receiver(pre_save, sender=Book)
# def check_pdf_change(sender, instance, **kwargs):
#     print("SIGNALS CALLED")
#     if not instance.pk:
#         # New instance
#         if instance.pdf:
#             file_id = upload_pdf_to_openai(instance.pdf.path)
#             if file_id:
#                 instance.openai_book_id = file_id
#         return

#     try:
#         old_instance = sender.objects.get(pk=instance.pk)
#     except sender.DoesNotExist:
#         return

#     if instance.pdf and instance.pdf != old_instance.pdf:
#         print(f"PDF changed from {old_instance.pdf} to {instance.pdf}")
#         file_id = upload_pdf_to_openai(instance.pdf.path)
#         if file_id:
#             instance.openai_book_id = file_id


@receiver(post_save, sender=Book)
def upload_pdf_after_save(sender, instance, created, **kwargs):
    if not instance.pdf:
        return  

    # Skip if already uploaded
    if instance.openai_book_id:
        return

    # Upload the file
    file_id = upload_pdf_to_openai(instance.pdf.path)
    if file_id:
        sender.objects.filter(pk=instance.pk).update(openai_book_id=file_id)
        print(f"OpenAI file uploaded, ID: {file_id}")