# Generated by Django 5.2.1 on 2025-05-28 10:57

import django.db.models.deletion
import django.utils.timezone
import library.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('library', '0002_verificationtest_subtest'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.AddField(
            model_name='book',
            name='allowed_account_ids',
            field=models.JSONField(default=library.models.default_account_ids),
        ),
        migrations.AddField(
            model_name='book',
            name='openai_book_id',
            field=models.CharField(blank=True, max_length=200, null=True),
        ),
        migrations.AddField(
            model_name='book',
            name='pdf',
            field=models.FileField(blank=True, null=True, upload_to='pdf-files/'),
        ),
        migrations.AlterField(
            model_name='book',
            name='created_at',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='book',
            name='updated_at',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('code', models.CharField(max_length=200)),
                ('cover_img', models.ImageField(blank=True, null=True, upload_to='project-cover-photo/')),
                ('report', models.FileField(blank=True, null=True, upload_to='project-files/')),
                ('visual_report', models.FileField(blank=True, null=True, upload_to='project-files/')),
                ('contractor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='project_contractor', to=settings.AUTH_USER_MODEL)),
                ('owner', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='project_owner', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='SubmissionRequest',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.IntegerField(choices=[(1, 'In Progress'), (2, 'Pending'), (3, 'Rejected'), (4, 'Complete')], default=2)),
                ('submission_file', models.FileField(blank=True, null=True, upload_to='submissions-files/')),
                ('submission_link', models.URLField(blank=True, null=True)),
                ('pdf', models.FileField(blank=True, null=True, upload_to='submissions-pdfs/')),
                ('url_360_viewer', models.URLField(blank=True, null=True)),
                ('matterport_link', models.URLField(blank=True, null=True)),
                ('workflow_state', models.IntegerField(choices=[(1, 'AI Powered Site Inspection'), (2, 'Generative AI PIM'), (3, 'Structural Analysis'), (4, 'Automated Code'), (5, 'Integration')], default=1)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='submission_requests', to='library.project')),
            ],
        ),
    ]
