# Generated by Django 5.2.1 on 2025-05-26 18:10

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Collection',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title_en', models.CharField(max_length=200)),
                ('title_ar', models.CharField(max_length=200)),
                ('order', models.IntegerField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='Language',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('lang', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title_en', models.CharField(max_length=200)),
                ('title_ar', models.CharField(max_length=200)),
                ('color', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='TargetAudience',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title_en', models.CharField(max_length=200)),
                ('title_ar', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='Book',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cover_img', models.ImageField(upload_to='book-cover-photo/')),
                ('title_en', models.CharField(max_length=200)),
                ('title_ar', models.CharField(max_length=200)),
                ('about_en', models.TextField()),
                ('about_ar', models.TextField()),
                ('brief_about_en', models.TextField(blank=True, null=True)),
                ('brief_about_ar', models.TextField(blank=True, null=True)),
                ('page_no', models.IntegerField(default=0)),
                ('webbook', models.URLField(blank=True, null=True)),
                ('epub', models.FileField(blank=True, null=True, upload_to='epub-files/')),
                ('order', models.IntegerField(default=0)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('publish_date', models.DateField(blank=True, null=True)),
                ('direction', models.CharField(choices=[('LTR', 'Left-to-Right'), ('RTL', 'Right-to-Left')], default='LTR', max_length=3)),
                ('author', models.CharField(blank=True, max_length=200, null=True)),
                ('price', models.FloatField(default=0.0)),
                ('views', models.IntegerField(default=0)),
                ('collection', models.ManyToManyField(related_name='books_collections', to='library.collection')),
                ('book_lang', models.ManyToManyField(related_name='books_langs', to='library.language')),
                ('tag', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='book_tags', to='library.tag')),
                ('target_audience', models.ManyToManyField(related_name='books_TrgAudience', to='library.targetaudience')),
            ],
        ),
    ]
