# urls.py

from django.urls import path
from .views import CourseListView, UserRegisteredCoursesView, CourseVideosView, VideoDetailView, CourseSearchAPIView, TempListView, HomePageApi \
, CustomerMailCreateView, CustomerHappinessRecordCreateView, ContactUsCreateView, CourseCollectionListView, VideoQuestionAPIView, MarkVideoWatchedAPIView, CourseQuizAPIView, QuizSubmissionAPIView, CourseEnrollmentAPIView

urlpatterns = [
    path('all/', CourseListView.as_view(), name='course-list'),
    path('user-registered-courses/', UserRegisteredCoursesView.as_view(), name='user-registered-courses'),
    path('<int:id>/videos/', CourseVideosView.as_view(), name='course-videos'),
    path('<int:course_id>/quiz/', CourseQuizAPIView.as_view(), name='course-quiz'),
    path('quiz/submit/', QuizSubmissionAPIView.as_view(), name='quiz-submit'),
    path('videos/<int:id>/', VideoDetailView.as_view(), name='video-detail'),
    path('videos/<int:video_id>/questions/', VideoQuestionAPIView.as_view(), name='video-questions'),
    path('videos/mark-watched/', MarkVideoWatchedAPIView.as_view(), name='mark-video-watched'),
    path('search/', CourseSearchAPIView.as_view(), name='course-search'),
    path('temp/all', TempListView.as_view(), name='temp-list'),
    path('homepage', HomePageApi.as_view(), name='home-page'),
    path('customer-mail/', CustomerMailCreateView.as_view(), name='customer-mail-create'),
    path('customer-happiness/', CustomerHappinessRecordCreateView.as_view(), name='customer-happiness-create'),
    path('contact-us', ContactUsCreateView.as_view(), name='contact-us-create'),
    path('collections', CourseCollectionListView.as_view(), name='course-collection-list'),
    path('enroll/', CourseEnrollmentAPIView.as_view(), name='course-enrollment'),
]
