import datetime
from django.db import models
# Create your models here.

class Course(models.Model):
    cover_photo = models.ImageField(upload_to='course-cover-photo/', blank=True, null=True)
    title_ar = models.CharField(max_length=200)
    title_en = models.CharField(max_length=200)
    about_ar = models.TextField()
    about_en = models.TextField()
    brief_about_en = models.TextField()
    brief_about_ar = models.TextField()
    views = models.IntegerField(default=0)
    order = models.IntegerField(default=0)
    price = models.FloatField(default=0.0)
    tag = models.ForeignKey('library.Tag', on_delete=models.SET_NULL, null=True, blank=True, related_name='course_tags')
    course_lang = models.ManyToManyField('library.Language', related_name='course_langs')
    subtitle_lang = models.ManyToManyField('library.Language', related_name='subtitle_course_langs', blank=True)
    target_audience = models.ManyToManyField('library.TargetAudience', related_name='course_TrgAudience')
    collection = models.ManyToManyField('CourseCollection', related_name='course_collections', blank=True)
    production_date = models.DateField(blank=True, null=True)
    allowed_account_ids = models.JSONField(default=list)
    pdus = models.PositiveIntegerField(default=0)
    has_quiz = models.BooleanField(default=False)
    def __str__(self) -> str:
        return f"{self.title_ar}-{self.title_en}"
    
class Video(models.Model):
    Course = models.ForeignKey('Course', on_delete=models.CASCADE, related_name='videos')
    cover_photo = models.ImageField(upload_to='video-cover-photo/', blank=True, null=True)
    title_ar = models.CharField(max_length=200)
    title_en = models.CharField(max_length=200)
    about_ar = models.TextField()
    about_en = models.TextField()
    brief_about_en = models.TextField()
    brief_about_ar = models.TextField()
    link = models.URLField()
    duration = models.DurationField()
    transcript_ar = models.URLField(blank=True, null=True)
    transcript_en = models.URLField(null=True, blank=True)
    order = models.IntegerField(default=0)
    release_date = models.DateField()
    video_lang = models.ManyToManyField('library.Language',related_name='video_langs')
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self) -> str:
        return f"{self.title_ar}-{self.title_en}"
    
    
class Question(models.Model):
    RIGHT_CHOICES = [
        ('A', 'Choice A'),
        ('B', 'Choice B'),
        ('C', 'Choice C'),
        ('D', 'Choice D'),
    ]
    question = models.TextField()
    timestamp = models.TimeField(blank=True, null=True)
    order = models.PositiveIntegerField(blank=True, null=True)
    choice_a = models.TextField()
    choice_b = models.TextField()
    choice_c = models.TextField()
    choice_d = models.TextField()
    video = models.ForeignKey('Video', on_delete=models.CASCADE , blank=True, null=True , related_name='video_questions')    
    course = models.ForeignKey('Course', on_delete=models.CASCADE , blank=True, null=True , related_name='course_questions') 
    right_choice = models.CharField(max_length=1 , choices=RIGHT_CHOICES)   
    
    def __str__(self):
        return self.question
    
    
class UserCourse(models.Model):
    user = models.ForeignKey('user_management.User', on_delete=models.CASCADE)   
    course = models.ForeignKey('Course', on_delete=models.CASCADE)
    quiz_grades = models.PositiveIntegerField(blank=True, null=True)
    tries = models.PositiveIntegerField(default=0)
    is_finished = models.BooleanField(default=False)  
    finished_date = models.DateTimeField(blank=True, null=True) # the datetime of the last quiz 

    
    def __str__(self):
        return f"{self.user.username}-{self.quiz_grades}"
    
    
class Temporary(models.Model):
    title_ar = models.CharField(max_length=200, blank=True, null=True)
    title_en = models.CharField(max_length=200, blank=True, null=True)
    about_ar = models.TextField(blank=True, null=True)
    about_en = models.TextField(blank=True, null=True)
    link = models.URLField(blank=True, null=True)
    cover_photo = models.ImageField(upload_to='temp-cover-photo/', blank=True, null=True)
    icon = models.FileField(upload_to='temp-icon-photo/', blank=True, null=True)
    color = models.CharField(max_length=200, blank=True, null=True)
    order = models.IntegerField(default=0)
    hide = models.BooleanField(default=False)

    def __str__(self) -> str:
        return f"{self.title_ar}-{self.title_en}"
    
class CustomerMail(models.Model):
    customer_mail = models.EmailField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self) -> str:
        return self.customer_mail
    
class CustomerHappinessRecord(models.Model):
    customer_rate = models.IntegerField()
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self) -> str:
        return self.customer_rate
    
class ContactUs(models.Model):
    name = models.CharField(max_length=200)
    phone = models.CharField(max_length=20)
    email = models.EmailField()
    message = models.TextField()

    def __str__(self) -> str:
        return self.name
    
class CourseCollection(models.Model):
    title_en = models.CharField(max_length=200)
    title_ar = models.CharField(max_length=200)
    order = models.IntegerField(default=0)

    def __str__(self) -> str:
        return f"{self.title_ar}-{self.title_en}"
