# Generated by Django 5.2.1 on 2025-05-26 18:10

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('library', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ContactUs',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('phone', models.CharField(max_length=20)),
                ('email', models.EmailField(max_length=254)),
                ('message', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='CourseCollection',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title_en', models.CharField(max_length=200)),
                ('title_ar', models.CharField(max_length=200)),
                ('order', models.IntegerField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='CustomerHappinessRecord',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('customer_rate', models.IntegerField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='CustomerMail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('customer_mail', models.EmailField(max_length=254)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Temporary',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title_ar', models.CharField(blank=True, max_length=200, null=True)),
                ('title_en', models.CharField(blank=True, max_length=200, null=True)),
                ('about_ar', models.TextField(blank=True, null=True)),
                ('about_en', models.TextField(blank=True, null=True)),
                ('link', models.URLField(blank=True, null=True)),
                ('cover_photo', models.ImageField(blank=True, null=True, upload_to='temp-cover-photo/')),
                ('icon', models.FileField(blank=True, null=True, upload_to='temp-icon-photo/')),
                ('color', models.CharField(blank=True, max_length=200, null=True)),
                ('order', models.IntegerField(default=0)),
                ('hide', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='Course',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cover_photo', models.ImageField(blank=True, null=True, upload_to='course-cover-photo/')),
                ('title_ar', models.CharField(max_length=200)),
                ('title_en', models.CharField(max_length=200)),
                ('about_ar', models.TextField()),
                ('about_en', models.TextField()),
                ('brief_about_en', models.TextField()),
                ('brief_about_ar', models.TextField()),
                ('views', models.IntegerField(default=0)),
                ('order', models.IntegerField(default=0)),
                ('price', models.FloatField(default=0.0)),
                ('production_date', models.DateField(blank=True, null=True)),
                ('course_lang', models.ManyToManyField(related_name='course_langs', to='library.language')),
                ('subtitle_lang', models.ManyToManyField(blank=True, related_name='subtitle_course_langs', to='library.language')),
                ('tag', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='course_tags', to='library.tag')),
                ('target_audience', models.ManyToManyField(related_name='course_TrgAudience', to='library.targetaudience')),
                ('collection', models.ManyToManyField(blank=True, related_name='course_collections', to='course.coursecollection')),
            ],
        ),
        migrations.CreateModel(
            name='Video',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cover_photo', models.ImageField(blank=True, null=True, upload_to='video-cover-photo/')),
                ('title_ar', models.CharField(max_length=200)),
                ('title_en', models.CharField(max_length=200)),
                ('about_ar', models.TextField()),
                ('about_en', models.TextField()),
                ('brief_about_en', models.TextField()),
                ('brief_about_ar', models.TextField()),
                ('link', models.URLField()),
                ('duratrion', models.DurationField()),
                ('transcript_ar', models.URLField(blank=True, null=True)),
                ('transcript_en', models.URLField(blank=True, null=True)),
                ('order', models.IntegerField(default=0)),
                ('release_date', models.DateField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('Course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='videos', to='course.course')),
                ('video_lang', models.ManyToManyField(related_name='video_langs', to='library.language')),
            ],
        ),
    ]
