"""
Django settings for Baldya project.

Generated by 'django-admin startproject' using Django 5.0.7.

For more information on this file, see
https://docs.djangoproject.com/en/5.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/5.0/ref/settings/
"""

from pathlib import Path
from corsheaders.defaults import default_headers
from datetime import timedelta
import os

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/5.0/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'django-insecure-jbun9--i@cq7tzr3h-mmzcw&&z(qbb6-^3#wuwfm3krv#-(r&e'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ['*']


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'rest_framework',
    'corsheaders',
    'django_filters',
    'library',
    'course',
    'user_management',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'corsheaders.middleware.CorsMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    
]

CORS_ALLOW_ALL_ORIGINS = True

CORS_ALLOW_HEADERS = [
    *default_headers,
    'x-api-key',
    'Content-Type',
    'Authorization',
]

ROOT_URLCONF = 'Baldya.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'Baldya.wsgi.application'


# Database
# https://docs.djangoproject.com/en/5.0/ref/settings/#databases

# DATABASES = {
#     'default': {
#         'ENGINE': 'django.db.backends.postgresql',
#         'NAME': 'baldya',
#         'USER': 'postgres',
#         'PASSWORD': 'admin',
#         'HOST': 'localhost',  # Set to your database host, e.g., 'localhost' for local development
#         'PORT': '5432',       # Set to your database port, default is 5432
#     }
# }

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': BASE_DIR / 'db.sqlite3',
    }
}



# Password validation
# https://docs.djangoproject.com/en/5.0/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/5.0/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/5.0/howto/static-files/

STATIC_URL = '/static/'
STATIC_ROOT = os.path.join(BASE_DIR, 'static/')

# Media files
MEDIA_URL = '/media/'
MEDIA_ROOT = os.path.join(BASE_DIR, 'media/')


# Default primary key field type
# https://docs.djangoproject.com/en/5.0/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'


REST_FRAMEWORK = {
    'DEFAULT_PAGINATION_CLASS': 'rest_framework.pagination.PageNumberPagination',
    'PAGE_SIZE': 10,  # Number of items per page
    'DEFAULT_AUTHENTICATION_CLASSES': (
        'rest_framework_simplejwt.authentication.JWTAuthentication',
    ),
    'DEFAULT_PERMISSION_CLASSES': (
        'rest_framework.permissions.IsAuthenticated',  # Allow access unless overridden
    ),
}


EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'
EMAIL_HOST = 'smtp.dmt.gov.ae'  # Replace with your SMTP host, like smtp.gmail.com
EMAIL_PORT = 25  # or 465 for SSL
EMAIL_USE_TLS = True  # Use TLS or SSL depending on your SMTP server
EMAIL_USE_SSL = False  # Set to True if you're using SSL (on port 465)
EMAIL_HOST_USER = 'bimaisupport@dmt.gov.ae'  # Your SMTP server's email address
EMAIL_HOST_PASSWORD = 'V0d@fon3.2o24'  # Your email account's password
DEFAULT_FROM_EMAIL = 'bimaisupport@dmt.gov.ae'  # Default sender email

# custome user
AUTH_USER_MODEL = 'user_management.User'

# X-API-KEY
API_KEY = "lE7xAtZETYdIm100IhjFzhYf_pmJVFFZ3B2_p4VEP6wur_70bUZoCs4Wfd2wqKEEcGeXwWNW3LBe0SGE6W6rGw"

#uae pass credentials 

UAE_PASS = {
    'CLIENT_ID': 'sandbox_stage',
    'CLIENT_SECRET': 'sandbox_stage',
    'REDIRECT_URI': 'https://abelrahmannasser.pythonanywhere.com/api/user_management/callback',
    # 'REDIRECT_URI': 'https://stg-selfcare.uaepass.ae',
    'AUTHORIZATION_URL': 'https://stg-id.uaepass.ae/idshub/authorize',
    'TOKEN_URL': 'https://stg-id.uaepass.ae/idshub/token',
    'USER_INFO_URL': 'https://stg-id.uaepass.ae/idshub/userinfo',
    'ACR_VALUES': 'urn:safelayer:tws:policies:authentication:level:low'
}


SIMPLE_JWT = {
    'ACCESS_TOKEN_LIFETIME': timedelta(hours=1),  
    'REFRESH_TOKEN_LIFETIME': timedelta(days=1),
    'ROTATE_REFRESH_TOKENS': False,
    'BLACKLIST_AFTER_ROTATION': True,

    'ALGORITHM': 'HS256',
    'SIGNING_KEY': SECRET_KEY,
    'AUTH_HEADER_TYPES': ('Bearer',),
    'AUTH_TOKEN_CLASSES': ('rest_framework_simplejwt.tokens.AccessToken',),
}

# openai configurations

OPENAI_API_KEY = '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'
OPENAI_ASSISTANT_ID = 'asst_84rRksLIlMs37MGcJw5FnFPC'

# autodesk credentials
CLIENT_ID = "jSBBEbxAqVMdFAhiqopoIpPcoJX0pglGmrGlF0lXxIdeMtsd"
CLIENT_SECRET = "KbJ7RT1y0AROEuYPGu5NQpTn70Acf2WE6jENKeVb3TGaQyGujL5zLDdvt6DQ1xIz"

AUTODESK_OAUTH_URL ="https://developer.api.autodesk.com/authentication/v2"
AUTODESK_CLIENT_ID = "QjDS0i2nNLUpeEBlXoXqRIBQ5B3TKADUhv5FzJq5rZVdh4fF"
AUTODESK_CLIENT_SECRET = "Z2r7BsshxA0VvXXyuCPhBIivxBZ5fKN9x3XIWo26NgUiCwIJCanm2Oz9HsOBqj23"
AUTODESK_CALLBACK_URL="http://localhost:8000/api/user_management/autodesk/callback/"
AUTODESK_FORGE_BASE = "https://developer.api.autodesk.com"

FILE_UPLOAD_MAX_MEMORY_SIZE = 10 * 1024 * 1024  # 10MB - files larger than this go to temp file
DATA_UPLOAD_MAX_MEMORY_SIZE = 10 * 1024 * 1024  # 10MB
FILE_UPLOAD_TEMP_DIR = '/tmp'  # Ensure you have enough space
# Cache
CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.filebased.FileBasedCache',
        'LOCATION': '/tmp/django_cache',
    }
}